function value = Value_Function(p, c, s, V, h, beta, S)
% Computes the value function value for remaining capacity c and time period s
%
% Inputs:
%   p: Current price.
%   c: Remaining capacity.
%   s: Time period.
%   V: Value function matrix calculated so far.
%   h: Function handle corresponding to the demand function.
%   beta: Vector of parameter estimates of the demand function.
%   S: Number of time periods in the selling season.
%
% Outputs:
%   value: Value function in (c, s).

if c == 1 %no seats are left
    value = 0;
else
    beta0 = beta(1);
    beta1 = beta(2);
    
    if length(beta) == 2
        
        % probability of selling one seat
        prob_sell = h(beta0+beta1*p);
        
        value = prob_sell*(p + V(c-1,s+1)) + (1-prob_sell)*V(c,s+1);
        
    elseif length(beta) == 3
        
        beta2 = beta(3);
        
        DTD = S-s+1;
        prob_sell = h(beta0+beta1*p+beta2*DTD);
        
        value = prob_sell*(p + V(c-1,s+1)) + (1-prob_sell)*V(c,s+1);
        
        
    end
    
end

end